//
// Fragment shader for Ripple effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

uniform float time;
uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect;

varying vec2 gUV;

//uniform sampler2D tex0;
//precision highp float;
//uniform float time;
//uniform vec2 resolution;
const float PI = 3.1415926535897932;

//speed
const float speed = 0.2;
const float speed_x = 0.3;
const float speed_y = 0.3;

// geometry
const float intensity = 3.;
const int steps = 8;
const float frequency = 4.0;
const int angle = 7; // better when a prime

// reflection and emboss
const float delta = 20.;
const float intence = 400.;
const float emboss = 0.3;

//---------- crystals effect

float col(vec2 coord)
{
    float delta_theta = 2.0 * PI / float(angle);
    float col = 0.0;
    float theta = 0.0;
    
    for (int i = 0; i < steps; i++)
    {
      vec2 adjc = coord;
      theta = delta_theta*float(i);
      adjc.x += cos(theta)*time*speed + time * speed_x;
      adjc.y -= sin(theta)*time*speed - time * speed_y;
      col = col + cos( (adjc.x*cos(theta) - adjc.y*sin(theta))*frequency)*intensity;
    }

    return cos(col);
}
bool InBound(float x, float a, float b)
{
    return (x > a && x<=b);
}
//---------- main

void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w;

        vec2 drawingBoundsOrigin = drawingBoundsRect.xy;
        float drawingBoundsWidth = drawingBoundsRect.z;
        float drawingBoundsHeight = drawingBoundsRect.w;
        
        vec2 p = gUV/vec2(textureRect.x+textureWidth, textureRect.y+textureHeight);
       
        vec2 c1 = p;
        vec2 c2 = p;
        float cc1 = col(c1);

        c2.x += drawingBoundsWidth/delta;
        float dx = emboss*(cc1-col(c2))/delta;

        c2.x = p.x;
        c2.y += drawingBoundsHeight/delta;
        float dy = emboss*(cc1-col(c2))/delta;

        c1.x += dx;
        c1.y += dy;
      //  c1.y = -c1.y;
        
        float alpha = 1.+dot(dx,dy)*intence;

        vec2 uv = c1*vec2(textureRect.x+textureWidth, textureRect.y+textureHeight);
        uv.x = InBound(uv.x, textureRect.x, textureRect.x+textureWidth)?uv.x:gUV.x;
        uv.y = InBound(uv.y, textureRect.y, textureRect.y+textureHeight)?uv.y:gUV.y;

        vec4 col =texture2DRect(texUnit,uv);

        gl_FragColor = modulateColor*vec4(col.rgb*(alpha), col.a);
        gl_FragColor.a = texture2DRect(texUnit, gUV).a;
       
        //gl_FragColor = vec4(0,0,1,1);
    }
}
